
// 7-segment digits 0-9
// {Q0, Q1, Q2, Q3, Q4, Q5, Q6, Q7} --> {g, f, e, d, c, b, a, DP} 

#include <SPI.h>
#include <SoftPWM.h>

const int dm134_clock = 13;
const int dm134_latch = 10; // DM134B datasheet says active low but seems to be active high (like a '595)?
const int dm134_data = 11;
const int dm134_OE = 9; // output enable; Active LOW. Can be used to control brightness with PWM.
const int pingPin = 7; // Trigger Pin of Ultrasonic Sensor
const int echoPin = 6; // Echo Pin of Ultrasonic Sensor

int brightness = 4; // set display brightness. 1-5 
int brt = 0; // value for storing reversed PWM percentage

long int cnt = 0; // counter initial value = 0
unsigned long previousMillis = 0; 
const long interval = 100;

byte ssddigits[10] = // array without decimal points on
{
  B01111110,  // 0
  B00001100,  // 1
  B10110110,  // 2
  B10011110,  // 3
  B11001100,  // 4
  B11011010,  // 5
  B11111010,  // 6
  B01001110,  // 7
  B11111110,  // 8
  B11011110,  // 9
};

byte ssddigitsDP[10] = // array with decimal points on
{
  B01111111,  // 0
  B00001101,  // 1
  B10110111,  // 2
  B10011111,  // 3
  B11001101,  // 4
  B11011011,  // 5
  B11111011,  // 6
  B01001111,  // 7
  B11111111,  // 8
  B11011111,  // 9
};

void setup() 
{
  
  pinMode (dm134_clock, OUTPUT);
  pinMode (dm134_latch, OUTPUT);
  pinMode (dm134_data, OUTPUT);
  pinMode (dm134_OE,OUTPUT);
  pinMode(pingPin, OUTPUT);
  pinMode(echoPin, INPUT);
  digitalWrite(dm134_OE,LOW); // enable output of DM134B.
  setBrt();
  SoftPWMBegin();
  SoftPWMSet(9, 0); // init software PWM on pin 9. This pulses the DM134 OE pin on and off to control brightness.
  SoftPWMSetPercent(9, brt);
  Serial.begin(115200); 
  
}

void setBrt() // this changes the DM134 brightness logarithmic reversed scale to a more linear one

  {
    if (brightness == 1)
    brt = 90;

    else if (brightness == 2)
    brt = 75;

    else if (brightness == 3)
    brt = 50;

    else if (brightness == 4)
    brt = 30;

    else if (brightness == 5)
    brt = 0;
  }

long microsecondsToInches(long microseconds) 
  {
   return microseconds / 74 / 2;
  }

long microsecondsToCentimeters(long microseconds) 
  {
   return microseconds / 20 / 2; // was 29/2 (adjust to calibrate sensor)
  }


void loop() 
{
   
long duration, inches, cm, num;
  
   digitalWrite(pingPin, LOW);
   delayMicroseconds(2);
   digitalWrite(pingPin, HIGH);
   delayMicroseconds(10);
   digitalWrite(pingPin, LOW);
   duration = pulseIn(echoPin, HIGH);
   inches = microsecondsToInches(duration);
   cm = microsecondsToCentimeters(duration);
   Serial.print(inches);
   Serial.print("in, ");
   Serial.print(cm);
   Serial.print("cm");
   Serial.println();
   delay(100);

   // get digit 0
   int dig3 = cm % 10; // ones
   // get digit 1
   int dig2 = (cm / 10) % 10; // tens
   // get digit 2
   int dig1 = (cm / 100) % 10; // hundreds
   // get digit 3
   int dig0 = (cm / 1000) % 10; // thousands

   if (cm >450)
   {
     SPI.beginTransaction(SPISettings(8000000, LSBFIRST, SPI_MODE0));
     digitalWrite(dm134_latch,LOW);
     SPI.transfer(B00000000);
     SPI.transfer(B10100001);
     SPI.transfer(B10100000);
     SPI.transfer(B11110010);
     digitalWrite(dm134_latch,HIGH);
     SPI.endTransaction();     
   }

   else
   {
     SPI.beginTransaction(SPISettings(8000000, LSBFIRST, SPI_MODE0));
     digitalWrite(dm134_latch,LOW);
     SPI.transfer(ssddigits[dig3]); 
     SPI.transfer(ssddigits[dig2]);
     SPI.transfer(ssddigits[dig1]);
     SPI.transfer(ssddigits[dig0]);
     digitalWrite(dm134_latch,HIGH);
     SPI.endTransaction();
   }

  
   
}
