// DM134B test program using hardware SPI (or ShiftOut)
// This displays a seconds counter that counts from 0-999 seconds then resets.
// If you added a button and relevant code you could use this as a stopwatch.
// SoftPWM library used to avoid conflicts with timers and SPI when using hardware PWM
// the SoftPWM library allows the display brightness to be adjusted in software.
// This circuit will draw approx 600mA at full brightness displaying 8888 (21.5mA per segment) 
// If high brightness not required either back off using onboard brightness pot or set to max 4 
// brightness if using software control to adjust brightness through PWM. This will reduce power useage.
// For example if using for a clock you could automatically dim the display at night.

// 7-segment digits 0-9
// {Q0, Q1, Q2, Q3, Q4, Q5, Q6, Q7} --> {g, f, e, d, c, b, a, DP} 

#include <SPI.h>
#include <SoftPWM.h>

int dm134_clock = 13;
int dm134_latch = 10; // DM134B datasheet says active low but seems to be active high (like a '595)?
int dm134_data = 11;
int dm134_OE = 9; // output enable; Active LOW. Can be used to control brightness with PWM.

int brightness = 4; // set display brightness. 1-5 
int brt = 0; // value for storing reversed PWM percentage

long int cnt = 0; // counter initial value = 0
unsigned long previousMillis = 0; 
const long interval = 100;

byte ssddigits[10] = // array without decimal points on
{
  B01111110,  // 0
  B00001100,  // 1
  B10110110,  // 2
  B10011110,  // 3
  B11001100,  // 4
  B11011010,  // 5
  B11111010,  // 6
  B01001110,  // 7
  B11111110,  // 8
  B11011110,  // 9
};

byte ssddigitsDP[10] = // array with decimal points on
{
  B01111111,  // 0
  B00001101,  // 1
  B10110111,  // 2
  B10011111,  // 3
  B11001101,  // 4
  B11011011,  // 5
  B11111011,  // 6
  B01001111,  // 7
  B11111111,  // 8
  B11011111,  // 9
};

void setup() 
{
  
  pinMode (dm134_clock, OUTPUT);
  pinMode (dm134_latch, OUTPUT);
  pinMode (dm134_data, OUTPUT);
  pinMode (dm134_OE,OUTPUT);
  digitalWrite(dm134_OE,LOW); // enable output of DM134B.
  setBrt();
  SoftPWMBegin();
  SoftPWMSet(9, 0); // init software PWM on pin 9. This pulses the DM134 OE pin on and off to control brightness.
  SoftPWMSetPercent(9, brt);
  
}

void setBrt() // this changes the DM134 brightness logarithmic reversed scale to a more linear one

{
  if (brightness == 1)
  brt = 90;

  else if (brightness == 2)
  brt = 75;

  else if (brightness == 3)
  brt = 50;

  else if (brightness == 4)
  brt = 30;

  else if (brightness == 5)
  brt = 0;
}

void loop() 
{
   unsigned long currentMillis = millis();

  if (currentMillis - previousMillis >= interval) 
  {
    previousMillis = currentMillis;
    cnt++;   
  }
   
   if (cnt == 9999)
   {
     cnt = 0;
   }

   
   
   displayNum();
}

void displayNum()
{

//long int num = analogRead(0);
//long int num = 1234;
long int num = cnt;

// get digit 0
int dig3 = num % 10; // ones
// get digit 1
int dig2 = (num / 10) % 10; // tens
// get digit 2
int dig1 = (num / 100) % 10; // hundreds
// get digit 3
int dig0 = (num / 1000) % 10; // thousands

SPI.beginTransaction(SPISettings(8000000, LSBFIRST, SPI_MODE0));
digitalWrite(dm134_latch,LOW);
SPI.transfer(ssddigits[dig3]); 
SPI.transfer(ssddigitsDP[dig2]);
SPI.transfer(ssddigits[dig1]);
SPI.transfer(ssddigits[dig0]);
digitalWrite(dm134_latch,HIGH);
SPI.endTransaction();

/*
// shift out digits
digitalWrite(dm134_latch,LOW);
shiftOut(dm134_data, dm134_clock, LSBFIRST, ssddigits[dig3]); 
shiftOut(dm134_data, dm134_clock, LSBFIRST, ssddigits[dig2]); 
shiftOut(dm134_data, dm134_clock, LSBFIRST, ssddigitsDP[dig1]);
shiftOut(dm134_data, dm134_clock, LSBFIRST, ssddigits[dig0]);
//shiftOut(dm134_data, dm134_clock, LSBFIRST, B00000001); // DP test
//shiftOut(dm134_data, dm134_clock, LSBFIRST, B00000001); // DP test
digitalWrite(dm134_latch,HIGH); 

*/

}
