// scrolltext demo for Adafruit RGBmatrixPanel library.
// Demonstrates double-buffered animation on our 16x32 RGB LED matrix:
// http://www.adafruit.com/products/420

// Written by Limor Fried/Ladyada & Phil Burgess/PaintYourDragon
// for Adafruit Industries.
// BSD license, all text above must be included in any redistribution.

// modified by Adrian Smith 
// To do - add ability to change colours and text size. If text size is set to 1 can display 2 lines instead of one large
// This will have to be done via a serial menu or keyboard interface such as a PS2 or USB keyboard
// Also would be ideal if message(s) are stored in eeprom so they are remembered at next power on.
// Also could add "third" colour mode where the scrolling text colours gradually change (see scrolltext example for hue change)
// would need to adapt code for only 2 colours instead of 3.

#include "Adafruit_GFX.h"   // Core graphics library
#include "RGBmatrixPanel.h" // Hardware-specific library
#include "Button.h" // button library
#include <EEPROM.h>
#include "eepromanything.h"

// Similar to F(), but for PROGMEM string pointers rather than literals
#define F2(progmem_ptr) (const __FlashStringHelper *)progmem_ptr
#define max_char 100
#define max_char1 100

char message[max_char];    // stores you message
char message1[max_char]; 

char r_char;               // reads each character
char r_char1;
byte index = 0;            // defines the position into your array
byte index1 = 0;
int i;
char greeting[] = "Waiting for a message to be sent to display";            
char greeting1[] = "16x96 LED Matrix Sign ABCDEFGHIJKLMOPQRSTUVWXYZ 0123456789 ";

#define CLK 12  //Used to be 50!!!  // MUST be on PORTB! //used to work on 11
#define LAT A3
#define OE  8  //used to be 51!!
#define A   A4
#define B   A1
#define C   A2

#define NUMDISPLAYS 3
#define DOUBLEBUFFER true
RGBmatrixPanel matrix(A, B, C, CLK, LAT, OE, DOUBLEBUFFER, NUMDISPLAYS);
// Double-buffered mode consumes around 1.5k of RAM. May work on a UNO, will need to test. Reference: Tested & no it doesn't...

Button buttonA = Button(2,BUTTON_PULLUP_INTERNAL);       // Setup button A (using button library)
Button buttonB = Button(3,BUTTON_PULLUP_INTERNAL);       // Setup button A (using button library)

const char str[] PROGMEM = "16x96 LED Matrix Sign"; // preset messages stored in flash. Change as required
const char str1[] PROGMEM = "Test message ";
const char str2[] PROGMEM = "ABCDEFGHIJKLMOPQRSTUVWXYZ ";
const char str3[] PROGMEM = "0123456789 ";
const char str4[] PROGMEM = "abcdefghijklmnopqrstuvwxyz ";

int    textX   = matrix.width(),
       textMin = sizeof(str) * -24,
       hue     = 0;      

int redBright = 1;
int greenBright = 1;
int blueBright = 1;   
int mode = 0;

boolean messageEntered = false;
boolean message1Entered = false;
       
void setup() 
{
  matrix.begin();
  Serial.begin(9600); // set up serial port at 9600 bps
  ledtest();
  matrix.setTextWrap(false); // Allow text to run off right edge
  matrix.setTextSize(2);

  strcpy(message,greeting); 
  strcpy(message1,greeting1); 

  Serial.println(F("LED message display, type your message for line 1 or single line"));
  Serial.println(F("then press enter"));
}

void loop() 

{

// Brightness adjustment via external button
   if(buttonA.uniquePress())
     {
      redBright++,greenBright++,blueBright++ ;
      
        if (redBright,greenBright,blueBright == 8)
        {
         redBright,greenBright,blueBright = 1;         
        }
      return;
     }

   if(buttonB.uniquePress())

   {
     mode++;

      if (mode == 9)
       {
         mode = 0;
       }
   }

  switch(mode)
  {
    case 0:
    largeRed();
    break;
    case 1:
    largeYellow();
    break;
    case 2:
    largeBold();
    break;
    case 3:
    colweaveLarge();
    break;
    case 4:
    redTwoLine();
    break;
    case 5:
    yellowTwoLine();
    break;
    case 6:
    boldTwoLine();
    break;
    case 7:
    colweaveTwoLine();
    break;
    case 8:
    topRedBotYellow();
    break;
    case 9:
    botRedTopYellow(); 
    break;
  default:
    matrix.fillScreen(0);
  }
     
  if(Serial.available() && messageEntered == false && message1Entered == false)
   {     
        for(i=0; i<99; i++)
        {
          message[i] = '\0';
        } 
        //resets the index        
        index=0;

        for(i=0; i<99; i++)
        {
          message1[i] = '\0';
        } 
        //resets the index        
        index1=0;
   }

    //while is reading the message 
    while(Serial.available() > 0 && messageEntered == false)
   {
       //the message can have up to 100 characters 
      
      if(index < (max_char-1)) 
      {      
        r_char = Serial.read();      // Reads a character
        message[index] = r_char;     // Stores the character in message array
        index++;                     // Increment position
        Serial.println("");
        Serial.print(message);
      }         
        
     if(Serial.available()<1)
     {
       Serial.println("");
       Serial.print(F("Now enter message for line 2 or blank if single line"));
       Serial.println("");
       Serial.flush();
       messageEntered = true;                  
     }
    
   }

  while(Serial.available() > 0 && messageEntered == true)
   {
       //the message can have up to 100 characters 
      
      if(index1 < (max_char-1)) 
      {      
        r_char1 = Serial.read();      // Reads a character
        message1[index1] = r_char1;     // Stores the character in message array
        index1++;                     // Increment position
        Serial.println("");
        Serial.print(message1);
      }         
        
     if(Serial.available()<1)
     {
       Serial.println("");
       Serial.print(F("Message(s) successfully Entered"));
       Serial.println("");
       Serial.flush();
       message1Entered = true;                  
     }
    
   }
 
    
}

// end main loop

// functions 

void largeRed()
{
  // Clear background
  
  matrix.fillScreen(0);
  matrix.setTextSize(2);
  matrix.setTextColor(matrix.Color333(redBright, 0, 0));
  matrix.setCursor(textX, 1); // number after comma is vertical offset
  matrix.print(message);
  //matrix.print(F2(str)); // print preset message

  // Move text left (w/wrap)
  if((--textX) < textMin) textX = matrix.width();

  // Update display
  matrix.swapBuffers(false);
}

void largeYellow()
{
  // Clear background
  
  matrix.fillScreen(0);
  matrix.setTextSize(2);
  matrix.setTextColor(matrix.Color333(0, greenBright, 0));
  matrix.setCursor(textX, 1); // number after comma is vertical offset
  matrix.print(message);
  //matrix.print(F2(str)); // print preset message

  // Move text left (w/wrap)
  if((--textX) < textMin) textX = matrix.width();

  // Update display
  matrix.swapBuffers(false);
}

void redTwoLine()
{
   // Clear background
  matrix.fillScreen(0);
  matrix.setTextSize(1);
  matrix.setTextColor(matrix.Color333(redBright, 0, 0));
  matrix.setCursor(textX, 0);
  matrix.print(message);
  matrix.setCursor(textX, 8);
  matrix.print(message1);

  // Move text left (w/wrap)
  if((--textX) < textMin) textX = matrix.width();
  
  // Update display
  matrix.swapBuffers(false);
}

void yellowTwoLine()
{
   // Clear background
  matrix.fillScreen(0);
  matrix.setTextSize(1);
  matrix.setTextColor(matrix.Color333(0, greenBright, 0));
  matrix.setCursor(textX, 0);
  matrix.print(message);
  matrix.setCursor(textX, 8);
  matrix.print(message1);

  // Move text left (w/wrap)
  if((--textX) < textMin) textX = matrix.width();
  
  // Update display
  matrix.swapBuffers(false);
}

void boldTwoLine()

{
   // Clear background
  matrix.fillScreen(0);
  matrix.setTextSize(1);
  matrix.setTextColor(matrix.Color333(redBright, greenBright, 0));
  matrix.setCursor(textX, 0);
  matrix.print(message);
  matrix.setCursor(textX, 8);
  matrix.print(message1);

  // Move text left (w/wrap)
  if((--textX) < textMin) textX = matrix.width();
  
  // Update display
  matrix.swapBuffers(false);
}

void topRedBotYellow()

{
    // Clear background
  matrix.fillScreen(0);
  matrix.setTextSize(1);
  matrix.setTextColor(matrix.Color333(redBright, 0, 0));
  matrix.setCursor(textX, 0);
  matrix.print(message);
  matrix.setCursor(textX, 8);
  matrix.setTextColor(matrix.Color333(0, greenBright, 0));
  matrix.print(message1);

  // Move text left (w/wrap)
  if((--textX) < textMin) textX = matrix.width();
  
  // Update display
  matrix.swapBuffers(false);

}

void botRedTopYellow()

{
    // Clear background
  matrix.fillScreen(0);
  matrix.setTextSize(1);
  matrix.setTextColor(matrix.Color333(0, greenBright, 0));
  matrix.setCursor(textX, 0);
  matrix.print(message);
  matrix.setCursor(textX, 8);
  matrix.setTextColor(matrix.Color333(redBright, 0, 0));
  matrix.print(message1);

  // Move text left (w/wrap)
  if((--textX) < textMin) textX = matrix.width();
  
  // Update display
  matrix.swapBuffers(false);
}


void largeBold()

{
	// Clear background
  
  matrix.fillScreen(0);
  matrix.setTextSize(2);
  matrix.setTextColor(matrix.Color333(redBright, greenBright, 0));
  matrix.setCursor(textX, 1); // number after comma is vertical offset
  matrix.print(message);
  //matrix.print(F2(str)); // print preset message

  // Move text left (w/wrap)
  if((--textX) < textMin) textX = matrix.width();

  // Update display
  matrix.swapBuffers(false);
}

void colweaveLarge()

{
	 // Clear background
  matrix.fillScreen(0);
  matrix.setTextSize(2);
  matrix.setTextColor(matrix.ColorHSV(hue, 127, 255, true));
  matrix.setCursor(textX, 1);
  matrix.print(message);
  //matrix.print(F2(str));

  // Move text left (w/wrap), increase hue
  if((--textX) < textMin) textX = matrix.width();
  hue += 7;
  if(hue >= 1536) hue -= 1536;

  // Update display
  matrix.swapBuffers(false);
}

void colweaveTwoLine() // causes flicker if two lines are displayed at once

{
   // Clear background
  matrix.fillScreen(0);
  matrix.setTextSize(1);
  matrix.setTextColor(matrix.ColorHSV(hue, 127, 255, true));
  matrix.setCursor(textX, 0);
  matrix.print(message);
  matrix.setCursor(textX, 8);
  matrix.print(message1);

  // Move text left (w/wrap), increase hue
  if((--textX) < textMin) textX = matrix.width();
  hue += 7;
  if(hue >= 1536) hue -= 1536;

  // Update display
  matrix.swapBuffers(false);
  
}

void ledtest()

{
  matrix.fillScreen(matrix.Color333(1, 0, 0));
  matrix.swapBuffers(false);
  delay(1000);
  matrix.fillScreen(matrix.Color333(0, 1, 0));
  matrix.swapBuffers(false);
  delay(1000);
  matrix.fillScreen(matrix.Color333(1, 1, 0));
  matrix.swapBuffers(false);
  delay(1000);
  matrix.fillScreen(matrix.Color333(0, 0, 0));
  matrix.swapBuffers(false);
}
