// 5x7 single LED module scrolling message display test. 
// Special characters - ^ prints a heart, % prints a Darwinian symbol, # prints a solid block
// You can add your own characters by editing the pattern.cpp and pattern.h files accordingly
// Only capital letters are accepted and displayed.
// LED matrix display has to be ROW ANODE type.
// Pins 4 and 7 not used - could be used for software serial port for bluetooth / GSM but this may affect display as serial data received. 
// Fart Clock version - detects methane, & hydrogen present in a typical fart. If threshold is met, displays a message.

#include <FrequencyTimer2.h>
#include "Pattern.h"
#include <RTClib.h>
#include <Wire.h>
#include <avr/pgmspace.h> 
#include <EEPROM.h>
#include "EEPROMAnything.h"

const int rows[] = { 10, 11, 13, 5, 9, 6, 8 };   //row   1, 2, 3, 4, 5, 6, 7
const int cols[] = { 12, A1, 3, 2, A0 };         //column   1, 2, 3, 4, 5 swapped pins 0 with A0 and 1 with A1
#define max_char 100

char message[max_char];    // stores message
char r_char;               // reads each character
byte index = 0;            // defines the position into your array
int i;
int sensorPin = A2;
int sensorValue = 0;
int serial_data = 0;
int introshown = 0;
char dateBuffer[12];
      
char greeting[] = " "; // change this if you want to hard-code your message
String clock_msg= "";
char fartlevel1[] = "YOU CAN DO BETTER!";
char fartlevel2[] = "TWIST!";
char fartlevel3[] = "A BIT STINKY";
char fartlevel4[] = "YOUR DUCK HAS BAD BREATH";
char fartlevel5[] = "DONT SHIT YOURSELF";
char fartlevel6[] = "SEE A BOWEL SPECIALIST";
char intro[] = "FART CLOCK";

RTC_Millis rtc; // for testing - you should use a DS1307 or DS3231 instead and comment this out.
//RTC_DS1307 rtc; // comment this back in to use DS1307
char *daysOfTheWeek[] = {"SUN", "MON", "TUE", "WED", "THU", "FRI", "SAT"};
char *monthsOfyear[] = {"JAN", "FEB", "MAR", "APR", "MAY", "JUN", "JUL", "AUG", "SEP", "OCT", "NOV", "DEC"};

// Use 220 ohm resistors on pins D0,D1,D2,D3,D10 which will limit current to 14.5mA per pin. 

void setup()

{
//rtc.begin(); // comment back in if using DS1307 / DS3231
rtc.adjust(DateTime(F(__DATE__), F(__TIME__)));  // sets date and time of RTC to compile time; comment out after time has been set & re-upload
strcpy(message,greeting);
Serial.begin(9600);
Serial.print(F("Scrolling message display. Up to 40 characters can be displayed"));  // F specifies do not copy text string to SRAM
Serial.println("");
Serial.print(F("Type message to display (CAPS ONLY + numbers) and press enter / CR "));
Serial.println("");
Serial.print(F("Do not close serial window till message has been transferred "));
Serial.println("");
Serial.print(F("This may take up to 30 seconds"));
Serial.println("");

EEPROM_readAnything(0, message);

  for (int c = 0; c < NUM_COLS; c++)
  {
    pinMode(cols[c], OUTPUT);
    digitalWrite(cols[c], LOW);
  }

  for (int r = 0; r < NUM_ROWS; r++)
  {
    pinMode(rows[r], OUTPUT);
    digitalWrite(rows[r], LOW);
  }

  setPattern(&PATTERN_BLANK);
  
  FrequencyTimer2::disable();
  FrequencyTimer2::setPeriod(2000);
  FrequencyTimer2::setOnOverflow(displayByRows);
}

int col = NUM_COLS - 1;

//// FUNCTIONS/////

void displayByCols()
{
  digitalWrite(cols[col], HIGH);

  col++;
  if (col >= NUM_COLS)
    col = 0;

  for (int row = 0; row < NUM_ROWS; row++)
  {
    digitalWrite(rows[row], (screen[row][col]) ? HIGH : LOW);
  }
  digitalWrite(cols[col], LOW);
}

int row = NUM_ROWS - 1;

void displayByRows()
{
  digitalWrite(rows[row], LOW);
  
  row++;
  if (row >= NUM_ROWS)
    row = 0;
    
  for (int col = 0; col < NUM_COLS; col++)
  {
    digitalWrite(cols[col], (screen[row][col]) ? LOW : HIGH);
  }
  digitalWrite(rows[row], HIGH);
  
}

void makeclock_msg()
{
  //Construct String clock_msg
  DateTime now = rtc.now();
  clock_msg = monthsOfyear[now.month()-1]; // remove -1 if date is one month out. Depends on RTC
  clock_msg +=' ';
  clock_msg += now.day();
  clock_msg += ", ";
  clock_msg += now.year();
  clock_msg += ", ";
  clock_msg += daysOfTheWeek[now.dayOfTheWeek()];
  clock_msg += " ";
  sprintf(dateBuffer,"%02u:%02u ",now.hour(),now.minute()); // add leading zero if hrs and or mins are less than 10
  clock_msg +=(dateBuffer);
 
}

void scrollintro()

{
  scrollString(intro, 500, 2); // numbers after message are speed (in ms) and gap between characters (in pixels)
  introshown = 1;
}

void detectFart()

{
  
  sensorValue = analogRead(sensorPin);       // read analog input pin 
        
              if (sensorValue < 400)
                
              {
               delay(2); 
               scrollString(message, 750, 2); // numbers after message are speed (in ms) and gap between characters (in pixels)
               delay(2);   // delays needed to allow ADC to switch between analog an digital mode as we are using some analog pins to drive the LED matrix
              }
                            
              else
              {
                  if (sensorValue >= 850)
                                  
                  {
                    delay(2);
                    scrollString(fartlevel6, 400, 2);
                    delay(2);
                  } 
                  
                  else if (sensorValue >= 750)
                  
                  {
                    delay(2);
                    scrollString(fartlevel5, 400, 2);
                    delay(2);
                  }
                  else if (sensorValue >= 700)
                  
                  {
                    delay(2);
                    scrollString(fartlevel4, 400, 2);
                    delay(2);
                  }
                  else if (sensorValue >= 600)
                 
                  {
                    delay(2);
                    scrollString(fartlevel3, 400, 2);
                    delay(2);
                  }
                  else if (sensorValue >= 500)
                  
                  {
                    delay(2);
                    scrollString(fartlevel2, 400, 2);
                    delay(2);
                  }
                  else if (sensorValue >= 400)
                  
                  {
                    delay(2);
                    scrollString(fartlevel1, 400, 2);
                    delay(2);
                  } 
              }

              Serial.print(sensorValue);
              Serial.println();
}



void probeSerial() // checks to see if there is data in the serial buffer

{
   if(Serial.available())
   {       
        for(i=0; i<99; i++){
            message[i] = '\0';
        } 
        //resets the index        
        index=0;
    }

    //while reading the message 
    while(Serial.available() > 0){
       //the message can have up to 100 characters 
      
       if(index < (max_char-1)) 
       {         
           r_char = Serial.read();      // Reads a character
           message[index] = r_char;     // Stores the character in message array
           index++;                     // Increment position
           Serial.println("");
           Serial.print(message);  
           EEPROM_writeAnything(0, message);                  
       } 
       
     if(Serial.available()<1)
     {
       Serial.println("");
       Serial.print(F("Message Transfer Complete"));
     }
   }

   
}

void loop()
{ 

if (introshown == 0)
  {
   scrollintro();
  }

   else
   {
     probeSerial();  // check serial buffer for data
     makeclock_msg(); // build the clock message string
     scrollString(clock_msg.c_str(), 400, 2); // numbers after message are speed (in ms, lower numbers = faster) and gap between characters (in pixels)
     probeSerial(); // do another serial buffer check before scrolling the message.
     detectFart(); // scan for fart and display message depending on severity otherwise display message from serial port
   }
}


